<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class UploadController extends Controller
{
    public function __invoke(Request $request)
    {
        $request->validate([
            'files' => ['required','array','max:10'],
            'files.*' => ['file','max:10240'], // 10MB each
        ]);

        $urls = [];
        foreach ($request->file('files') as $file) {
            $mime = $file->getMimeType();
            $type = str_contains($mime, 'image') ? 'image' : (str_contains($mime, 'video') ? 'video' : 'file');
            $path = $file->store('uploads', 'public');
            $urls[] = [
                'type' => $type,
                // Use asset() so apps served from a subdirectory generate correct URLs
                'url' => asset(Storage::url($path)),
                'name' => $file->getClientOriginalName(),
                'mime' => $mime,
            ];
        }

        return response()->json(['files' => $urls]);
    }
}
