<?php

namespace App\Integrations\Notification\Providers;

use App\Integrations\Notification\Contracts\SmsProvider;
use Illuminate\Support\Facades\Log;

class LogSmsProvider implements SmsProvider
{
    public function __construct(private array $config = [])
    {
    }

    public function send(string|array $recipients, string $message, array $options = []): void
    {
        Log::info('SMS queued (log driver)', [
            'recipients' => $recipients,
            'message' => $message,
            'options' => $options,
        ]);
    }
}
