<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Clan extends Model
{
    use HasFactory;

    protected $fillable = [
        'ethnic_group_id',
        'name',
        'description',
    ];

    public function ethnicGroup()
    {
        return $this->belongsTo(EthnicGroup::class);
    }

    public function ethnicGroups()
    {
        return $this->belongsToMany(EthnicGroup::class, 'clan_ethnic_group');
    }

    public function families()
    {
        return $this->hasMany(Family::class);
    }
}
