<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FamilyWallPost extends Model
{
    use HasFactory;

    protected $fillable = [
        'family_id',
        'author_id',
        'content',
        'media',
        'meta',
    ];

    protected $casts = [
        'media' => 'array',
        'meta' => 'array',
    ];

    public function family()
    {
        return $this->belongsTo(Family::class);
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'author_id');
    }

    public function comments()
    {
        return $this->hasMany(FamilyWallPostComment::class, 'family_wall_post_id');
    }

    public function reactions()
    {
        return $this->hasMany(FamilyWallPostReaction::class, 'family_wall_post_id');
    }
}
