<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FamilyWallPostReaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'family_wall_post_id',
        'user_id',
        'type',
        'meta',
    ];

    protected $casts = [
        'meta' => 'array',
    ];

    public function post()
    {
        return $this->belongsTo(FamilyWallPost::class, 'family_wall_post_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
