<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionPaymentMethod extends Model
{
    use HasFactory;

    protected $fillable = [
        'subscriber_type',
        'subscriber_id',
        'provider',
        'reference',
        'brand',
        'last_four',
        'expires_at',
        'is_default',
        'meta',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'is_default' => 'boolean',
        'meta' => 'array',
    ];

    public function subscriber()
    {
        return $this->morphTo();
    }
}
