<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TrafficEvent extends Model
{
    use HasFactory;

    protected $fillable = [
        'visit_id',
        'session_id',
        'user_id',
        'name',
        'properties',
    ];

    protected $casts = [
        'properties' => 'array',
    ];

    public function visit(): BelongsTo
    {
        return $this->belongsTo(TrafficVisit::class, 'visit_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
