<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TrafficVisit extends Model
{
    use HasFactory;

    protected $fillable = [
        'session_id',
        'user_id',
        'ip',
        'user_agent',
        'device',
        'platform',
        'browser',
        'method',
        'route_name',
        'path',
        'status_code',
        'referrer',
        'country',
        'city',
        'latitude',
        'longitude',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function events(): HasMany
    {
        return $this->hasMany(TrafficEvent::class, 'visit_id');
    }
}
