<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('family_wall_post_comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('family_wall_post_id')->constrained('family_wall_posts')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->text('content');
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->index(['family_wall_post_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('family_wall_post_comments');
    }
};
