<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RolesAndPermissionsSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            'users.manage',
            'families.manage',
            'people.manage',
            'invitations.manage',
            'relationships.manage',
            'events.manage',
            'commerce.manage',
            'subscriptions.manage',
            'subscriptions.view',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(
                ['name' => $permission, 'guard_name' => 'web'],
                []
            );
        }

        $roles = [
            'admin' => $permissions,
            'hr-head' => [
                'people.manage',
                'families.manage',
                'invitations.manage',
                'subscriptions.view',
            ],
            'hr-officer' => [
                'people.manage',
            ],
            'member' => [],
            'user' => [],
        ];

        foreach ($roles as $roleName => $rolePermissions) {
            $role = Role::firstOrCreate(['name' => $roleName, 'guard_name' => 'web']);
            $role->syncPermissions($rolePermissions);
        }
    }
}
