@extends('layouts.app')

@section('title', 'Clans · Admin')
@section('page-title', 'Clans / Lineages')
@section('wide', 'true')

@section('content')
    <section class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <form method="GET" class="flex items-end gap-3">
                <div>
                    <label class="block text-xs text-slate-500">Filter by ethnic group</label>
                    <select name="ethnic_group_id" class="rounded-xl border-slate-200">
                        <option value="">All</option>
                        @foreach($groups as $g)
                            <option value="{{ $g->id }}" @selected($gid == $g->id)>{{ $g->name }} ({{ $g->country_code }})</option>
                        @endforeach
                    </select>
                </div>
                <button class="px-3 py-2 rounded-xl bg-primary text-white text-sm">Apply</button>
            </form>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div class="rounded-2xl border border-slate-100 bg-white p-6">
                <h3 class="text-sm font-semibold text-ink mb-3">Create clan / lineage</h3>
                <form method="POST" action="{{ route('admin.clans.store') }}" class="space-y-3">
                    @csrf
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                        <div>
                            <label class="block text-xs text-slate-500">Ethnic group(s)</label>
                            <select name="ethnic_group_ids[]" class="w-full rounded-xl border-slate-200" multiple required size="4">
                                @foreach($groups as $g)
                                    <option value="{{ $g->id }}" @selected($gid == $g->id)>{{ $g->name }} ({{ $g->country_code }})</option>
                                @endforeach
                            </select>
                            <p class="mt-1 text-xs text-slate-500">Hold Ctrl/Cmd to select multiple.</p>
                        </div>
                        <div>
                            <label class="block text-xs text-slate-500">Clan / Lineage name</label>
                            <input name="name" class="w-full rounded-xl border-slate-200" required />
                        </div>
                        <div class="sm:col-span-2">
                            <label class="block text-xs text-slate-500">Description</label>
                            <textarea name="description" rows="3" class="w-full rounded-xl border-slate-200"></textarea>
                        </div>
                    </div>
                    <button class="px-4 py-2 rounded-xl bg-primary text-white text-sm">Create</button>
                </form>
            </div>

            <div class="rounded-2xl border border-slate-100 bg-white p-6 overflow-auto">
                <h3 class="text-sm font-semibold text-ink mb-3">Existing clans</h3>
                <table class="w-full text-sm">
                    <thead>
                        <tr class="text-left text-slate-500">
                            <th class="py-2">Name</th>
                            <th class="py-2">Ethnic group(s)</th>
                            <th class="py-2">Country/ies</th>
                            <th class="py-2">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    @forelse($clans as $c)
                        <tr class="border-t border-slate-100">
                            <td class="py-2 align-top">
                                <form method="POST" action="{{ route('admin.clans.update', $c) }}" class="space-y-2">
                                    @csrf
                                    @method('PATCH')
                                    <input name="name" value="{{ $c->name }}" class="rounded-xl border-slate-200 w-full" />
                                    <textarea name="description" rows="2" class="rounded-xl border-slate-200 w-full" placeholder="Description">{{ $c->description }}</textarea>
                            </td>
                            <td class="py-2 align-top">
                                    <select name="ethnic_group_ids[]" class="rounded-xl border-slate-200" multiple size="4">
                                        @php($selected = $c->ethnicGroups->pluck('id')->push($c->ethnic_group_id)->unique()->all())
                                        @foreach($groups as $g)
                                            <option value="{{ $g->id }}" @selected(in_array($g->id, $selected))>{{ $g->name }}</option>
                                        @endforeach
                                    </select>
                            </td>
                            <td class="py-2 align-top">
                                @php($countries = $c->ethnicGroups->pluck('country_code')->push(optional($c->ethnicGroup)->country_code)->filter()->unique()->values()->all())
                                {{ implode(', ', $countries) }}
                            </td>
                            <td class="py-2 align-top whitespace-nowrap">
                                    <button class="px-3 py-1.5 rounded-lg bg-primary text-white">Save</button>
                                </form>
                                <form method="POST" action="{{ route('admin.clans.destroy', $c) }}" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button class="px-3 py-1.5 rounded-lg bg-rose-50 text-rose-700" onclick="return confirm('Delete this clan?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr><td colspan="4" class="py-4 text-slate-500">No clans yet.</td></tr>
                    @endforelse
                    </tbody>
                </table>
                <div class="mt-3">{{ $clans->withQueryString()->links() }}</div>
            </div>
        </div>
    </section>
@endsection
