@extends('layouts.app')

@section('title', 'Locations · Admin · FamilyTree')
@section('page-title', 'Locations Management')
@section('wide', 'true')

@section('content')
    <section class="space-y-6">
        @if (session('status'))
            <div class="rounded-xl bg-green-50 border border-green-200 text-green-800 px-4 py-3">{{ session('status') }}</div>
        @endif
        @if ($errors->any())
            <div class="rounded-xl bg-red-50 border border-red-200 text-red-800 px-4 py-3">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <div class="flex items-center justify-between">
                <h2 class="text-lg font-semibold text-slate-800">Countries</h2>
            </div>
            <div class="mt-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                    <tr class="text-left text-slate-500 border-b border-slate-100">
                        <th class="py-2 pr-4">Code</th>
                        <th class="py-2 pr-4">Name</th>
                        <th class="py-2 pr-4">Regions</th>
                        <th class="py-2 pr-4">Actions</th>
                    </tr>
                    </thead>
                    <tbody class="align-top">
                    @forelse($locations as $code => $country)
                        <tr class="border-b border-slate-100">
                            <td class="py-2 pr-4 font-mono text-xs">{{ $code }}</td>
                            <td class="py-2 pr-4">{{ $country['name'] ?? $code }}</td>
                            <td class="py-2 pr-4">{{ isset($country['regions']) ? count($country['regions']) : 0 }}</td>
                            <td class="py-2 pr-4 flex items-center gap-2">
                                <a href="{{ route('admin.locations.show', $code) }}" class="px-3 py-1.5 rounded-lg bg-primary text-white text-xs font-medium">Manage</a>
                                <form action="{{ route('admin.locations.delete', $code) }}" method="POST" onsubmit="return confirm('Delete country '+ '{{ $country['name'] ?? $code }}' +'? This cannot be undone.');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="px-3 py-1.5 rounded-lg bg-red-50 text-red-600 border border-red-200 text-xs font-medium">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="py-6 text-center text-slate-500">No countries configured yet.</td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <h3 class="text-base font-semibold text-slate-800">Add Country</h3>
            <form action="{{ route('admin.locations.store') }}" method="POST" class="mt-4 grid md:grid-cols-3 gap-4">
                @csrf
                <div>
                    <label for="code" class="block text-xs font-medium text-slate-500 mb-1">Country code (2–3 letters)</label>
                    <input type="text" id="code" name="code" value="{{ old('code') }}" class="w-full rounded-xl border border-slate-200 px-3 py-2" placeholder="GH" required>
                </div>
                <div class="md:col-span-2">
                    <label for="name" class="block text-xs font-medium text-slate-500 mb-1">Country name</label>
                    <input type="text" id="name" name="name" value="{{ old('name') }}" class="w-full rounded-xl border border-slate-200 px-3 py-2" placeholder="Ghana" required>
                </div>
                <div class="md:col-span-3 flex justify-end">
                    <button type="submit" class="px-4 py-2 rounded-xl bg-primary text-white font-medium">Create</button>
                </div>
            </form>
        </div>
    </section>
@endsection
