@extends('layouts.app')

@section('title', 'Family Announcements · FamilyTree')
@section('page-title', 'Family Announcements')

@section('content')
<section class="space-y-6">
    <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-base font-semibold text-slate-800">{{ $family->name }}</h2>
                <p class="text-xs text-slate-500">Send messages to specific members or the whole family</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('families.index') }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">chevron_left</span>
                    Back to directory
                </a>
                <a href="{{ route('families.tree', $family) }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">account_tree</span>
                    Tree
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Recent announcements</h3>
            <div class="space-y-3">
                @forelse($announcements as $a)
                    <article class="rounded-xl border border-slate-200 p-4">
                        <h4 class="text-sm font-semibold text-slate-800">{{ $a->title }}</h4>
                        <p class="text-xs text-slate-500">{{ optional($a->created_at)->diffForHumans() }}</p>
                        <p class="mt-2 text-sm text-slate-700">{{ $a->content }}</p>
                        <p class="mt-2 text-xs text-slate-500">
                            @if($a->send_to_all)
                                Sent to: All members
                            @else
                                Sent to:
                                @if($a->recipients->isEmpty())
                                    —
                                @else
                                    {{ $a->recipients->pluck('first_name')->map(fn($n) => trim($n))->implode(', ') }}
                                @endif
                            @endif
                        </p>
                        @if(!empty($canManage))
                            <div class="mt-3 flex items-center gap-2">
                                <a href="{{ route('families.announcements.index', [$family->id, 'edit' => $a->id]) }}" class="text-xs text-primary">Edit</a>
                                <form method="POST" action="{{ route('families.announcements.destroy', [$family->id, $a->id]) }}" onsubmit="return confirm('Delete this announcement?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-xs text-red-600">Delete</button>
                                </form>
                            </div>
                        @endif
                    </article>
                @empty
                    <p class="text-sm text-slate-500">No announcements yet.</p>
                @endforelse
            </div>
            <div class="mt-4">
                {{ $announcements->withQueryString()->links() }}
            </div>
        </div>

        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            @if(!empty($canCreate) || (!empty($canManage) && !empty($prefill)))
                <h3 class="text-sm font-semibold text-slate-700 mb-3">{{ !empty($prefill) ? 'Edit announcement' : 'Create announcement' }}</h3>
                <form method="POST" action="{{ !empty($prefill) ? route('families.announcements.update', [$family, $prefill['id']]) : route('families.announcements.store', $family) }}" class="space-y-4">
                    @csrf
                    @if(!empty($prefill))
                        @method('PUT')
                    @endif
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Title</label>
                        <input name="title" value="{{ old('title', $prefill['title'] ?? '') }}" required type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Announcement title">
                    </div>
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Message</label>
                        <textarea name="content" rows="4" required class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Write your message...">{{ old('content', $prefill['content'] ?? '') }}</textarea>
                    </div>
                    <div class="flex items-center gap-2">
                        <input id="sendAllToggle" name="send_to_all" type="checkbox" value="1" class="rounded border-slate-300 text-primary focus:ring-primary" {{ !empty($prefill) && !empty($prefill['send_to_all']) ? 'checked' : '' }}>
                        <label for="sendAllToggle" class="text-sm text-slate-700">Send to all family members</label>
                    </div>
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Select recipients (optional)</label>
                        <select id="recipientsSelect" name="recipients[]" multiple class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary h-40">
                            @php($selectedRecipients = collect(old('recipients', $prefill['recipients'] ?? []))->map(fn($v) => (int)$v)->all())
                            @foreach($members as $m)
                                <option value="{{ $m['id'] }}" {{ in_array($m['id'], $selectedRecipients, true) ? 'selected' : '' }}>{{ $m['name'] }}</option>
                            @endforeach
                        </select>
                        <p class="mt-1 text-xs text-slate-500">If "Send to all" is checked, the selection above is ignored.</p>
                    </div>
                    <div>
                        <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                            <span class="material-symbols-rounded">send</span>
                            {{ !empty($prefill) ? 'Save changes' : 'Send announcement' }}
                        </button>
                    </div>
                </form>
            @else
                <h3 class="text-sm font-semibold text-slate-700 mb-3">Create announcement</h3>
                <p class="text-sm text-slate-500">You don't have permission to create announcements. Please contact a family owner/manager.</p>
            @endif
        </div>
    </div>

    @if(!empty($canManage))
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Who can create announcements</h3>
            <form method="POST" action="{{ route('families.announcements.permissions.update', $family) }}" class="space-y-4">
                @csrf
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Select members</label>
                    <select name="creators[]" multiple class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary h-48">
                        @foreach($members as $m)
                            <option value="{{ $m['id'] }}" {{ in_array($m['id'], $creatorIds ?? [], true) ? 'selected' : '' }}>{{ $m['name'] }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                        <span class="material-symbols-rounded">save</span>
                        Save permissions
                    </button>
                </div>
            </form>
        </div>
    @endif
</section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function(){
        var allToggle = document.getElementById('sendAllToggle');
        var recipients = document.getElementById('recipientsSelect');
        function updateDisabled(){
            if (!allToggle || !recipients) return;
            var on = allToggle.checked;
            recipients.disabled = on;
            recipients.classList.toggle('opacity-60', on);
        }
        if (allToggle) {
            allToggle.addEventListener('change', updateDisabled);
            updateDisabled();
        }
    });
</script>
@endpush
