@extends('layouts.app')

@section('title', 'Family Events · FamilyTree')
@section('page-title', 'Family Events')

@section('content')
<section class="space-y-6">
    <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="text-base font-semibold text-slate-800">{{ $family->name }}</h2>
                <p class="text-xs text-slate-500">Upcoming events for this family</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('families.index') }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">chevron_left</span>
                    Back to directory
                </a>
                <a href="{{ route('families.tree', $family) }}" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                    <span class="material-symbols-rounded text-base">account_tree</span>
                    Tree
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Upcoming events</h3>
            <div class="space-y-3">
                @forelse($events as $event)
                    <article class="rounded-xl border border-slate-200 p-4">
                        <h4 class="text-sm font-semibold text-slate-800">{{ $event->title }}</h4>
                        <p class="text-xs text-slate-500">
                            {{ optional($event->starts_at)->format('M d, Y H:i') }}
                            @if($event->ends_at)
                                – {{ optional($event->ends_at)->format('M d, Y H:i') }}
                            @endif
                            @if($event->location)
                                · {{ $event->location }}
                            @endif
                        </p>
                        @if($event->description)
                            <p class="mt-2 text-sm text-slate-600">{{ $event->description }}</p>
                        @endif
                        @if(!empty($canManage))
                            <div class="mt-3 flex items-center gap-2">
                                <a href="{{ route('families.events.index', [$family->id, 'edit' => $event->id]) }}" class="text-xs text-primary">Edit</a>
                                <form method="POST" action="{{ route('families.events.destroy', [$family->id, $event->id]) }}" onsubmit="return confirm('Delete this event?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-xs text-red-600">Delete</button>
                                </form>
                            </div>
                        @endif
                    </article>
                @empty
                    <p class="text-sm text-slate-500">No events yet.</p>
                @endforelse
            </div>
        </div>

        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            @if(!empty($canCreate) || (!empty($canManage) && !empty($prefill)))
                <h3 class="text-sm font-semibold text-slate-700 mb-3">{{ !empty($prefill) ? 'Edit event' : 'Create event' }}</h3>
                <form method="POST" action="{{ !empty($prefill) ? route('families.events.update', [$family, $prefill['id']]) : route('families.events.store', $family) }}" class="space-y-4">
                    @csrf
                    @if(!empty($prefill))
                        @method('PUT')
                    @endif
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Title</label>
                        <input name="title" value="{{ old('title', $prefill['title'] ?? '') }}" required type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Event title">
                    </div>
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Description</label>
                        <textarea name="description" rows="3" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Short description">{{ old('description', $prefill['description'] ?? '') }}</textarea>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm text-slate-600 mb-1">Starts at</label>
                            <input name="starts_at" value="{{ old('starts_at', $prefill['starts_at'] ?? '') }}" required type="datetime-local" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary">
                        </div>
                        <div>
                            <label class="block text-sm text-slate-600 mb-1">Ends at</label>
                            <input name="ends_at" value="{{ old('ends_at', $prefill['ends_at'] ?? '') }}" type="datetime-local" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm text-slate-600 mb-1">Location</label>
                        <input name="location" value="{{ old('location', $prefill['location'] ?? '') }}" type="text" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" placeholder="Optional location">
                    </div>
                    <div>
                        <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                            <span class="material-symbols-rounded">event</span>
                            {{ !empty($prefill) ? 'Save changes' : 'Add event' }}
                        </button>
                    </div>
                </form>
            @else
                <h3 class="text-sm font-semibold text-slate-700 mb-3">Create event</h3>
                <p class="text-sm text-slate-500">You don't have permission to create events. Please contact a family owner/manager.</p>
            @endif
        </div>
    </div>

    @if(!empty($canManage))
        <div class="rounded-2xl border border-slate-100 bg-white p-6">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Who can create events</h3>
            <form method="POST" action="{{ route('families.events.permissions.update', $family) }}" class="space-y-4">
                @csrf
                <div>
                    <label class="block text-sm text-slate-600 mb-1">Select members</label>
                    <select name="creators[]" multiple class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary h-48">
                        @foreach($members as $m)
                            <option value="{{ $m['id'] }}" {{ in_array($m['id'], $creatorIds ?? [], true) ? 'selected' : '' }}>{{ $m['name'] }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2 rounded-xl">
                        <span class="material-symbols-rounded">save</span>
                        Save permissions
                    </button>
                </div>
            </form>
        </div>
    @endif
</section>
@endsection

@push('head')
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
@endpush
