<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <title>How It Works · {{ config('app.name', 'FamilyTree') }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
    @vite(['resources/css/app.css'])
    <style>
        .gradient-hero { background: radial-gradient(1200px 500px at 50% -50%, rgba(14,165,233,.25), rgba(99,102,241,.12), transparent 70%); }
    </style>
</head>
<body class="bg-slate-50 text-slate-800">
    <main id="main" class="min-h-screen">
        <section class="gradient-hero">
            <div class="max-w-6xl mx-auto px-4 lg:px-6 py-16 lg:py-24">
                <div class="text-center max-w-3xl mx-auto">
                    <div class="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-primary/10 text-primary text-xs font-semibold mb-4">
                        <span class="material-symbols-rounded text-base">auto_awesome</span>
                        {{ config('app.name', 'FamilyTree') }}
                    </div>
                    <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-slate-900">How {{ config('app.name', 'FamilyTree') }} Works</h1>
                    <p class="mt-4 text-slate-600 text-base md:text-lg">Build your family tree, share announcements, plan events, and keep everyone in the loop via in‑app, email, SMS (mNotify), and WhatsApp.</p>
                    <div class="mt-8 flex items-center justify-center gap-3">
                        <a href="{{ route('register') }}" class="inline-flex items-center gap-2 bg-primary text-white px-5 py-3 rounded-xl shadow-sm">
                            <span class="material-symbols-rounded">person_add</span>
                            Get started free
                        </a>
                        <a href="{{ route('login') }}" class="inline-flex items-center gap-2 bg-white text-slate-700 border border-slate-200 px-5 py-3 rounded-xl hover:bg-slate-50">
                            <span class="material-symbols-rounded">login</span>
                            Sign in
                        </a>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-12 lg:py-16">
            <div class="max-w-6xl mx-auto px-4 lg:px-6">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 lg:gap-8">
                    <div class="rounded-2xl border border-slate-200 bg-white p-6">
                        <div class="flex items-center gap-2 text-primary text-sm font-semibold">
                            <span class="material-symbols-rounded">groups</span>
                            Step 1
                        </div>
                        <h3 class="mt-2 text-lg font-semibold text-slate-800">Create your family and invite members</h3>
                        <p class="mt-2 text-sm text-slate-600">Spin up a private family space. Invite relatives by email or phone. They’ll receive links via email/SMS powered by mNotify.</p>
                    </div>
                    <div class="rounded-2xl border border-slate-200 bg-white p-6">
                        <div class="flex items-center gap-2 text-primary text-sm font-semibold">
                            <span class="material-symbols-rounded">account_tree</span>
                            Step 2
                        </div>
                        <h3 class="mt-2 text-lg font-semibold text-slate-800">Build your family tree</h3>
                        <p class="mt-2 text-sm text-slate-600">Add people and relationships over time. Capture stories, photos, and milestones in one living family archive.</p>
                    </div>
                    <div class="rounded-2xl border border-slate-200 bg-white p-6">
                        <div class="flex items-center gap-2 text-primary text-sm font-semibold">
                            <span class="material-symbols-rounded">campaign</span>
                            Step 3
                        </div>
                        <h3 class="mt-2 text-lg font-semibold text-slate-800">Share announcements and events</h3>
                        <p class="mt-2 text-sm text-slate-600">Post announcements to selected members or everyone. Plan events with dates, locations, and details.</p>
                        <ul class="mt-3 text-sm text-slate-600 list-disc pl-5 space-y-1">
                            <li>In‑app notifications for signed‑in users</li>
                            <li>Email updates using your configured sender</li>
                            <li>SMS via mNotify and optional WhatsApp relay</li>
                        </ul>
                    </div>
                    <div class="rounded-2xl border border-slate-200 bg-white p-6">
                        <div class="flex items-center gap-2 text-primary text-sm font-semibold">
                            <span class="material-symbols-rounded">schedule</span>
                            Step 4
                        </div>
                        <h3 class="mt-2 text-lg font-semibold text-slate-800">Stay on schedule with reminders</h3>
                        <p class="mt-2 text-sm text-slate-600">Set reminder days and time per family. Admins can also define global defaults. Members get timely nudges so no one misses a thing.</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-12 lg:py-16 bg-white">
            <div class="max-w-6xl mx-auto px-4 lg:px-6">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6 lg:gap-8">
                    <div class="rounded-2xl border border-slate-200 p-6">
                        <div class="h-10 w-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center">
                            <span class="material-symbols-rounded">lock</span>
                        </div>
                        <h4 class="mt-3 text-base font-semibold text-slate-800">Private by design</h4>
                        <p class="mt-2 text-sm text-slate-600">Your family space is private. Only members you invite can view and participate.</p>
                    </div>
                    <div class="rounded-2xl border border-slate-200 p-6">
                        <div class="h-10 w-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center">
                            <span class="material-symbols-rounded">admin_panel_settings</span>
                        </div>
                        <h4 class="mt-3 text-base font-semibold text-slate-800">Clear roles & permissions</h4>
                        <p class="mt-2 text-sm text-slate-600">Owners and managers control who can create announcements or events, keeping things organized.</p>
                    </div>
                    <div class="rounded-2xl border border-slate-200 p-6">
                        <div class="h-10 w-10 rounded-xl bg-primary/10 text-primary flex items-center justify-center">
                            <span class="material-symbols-rounded">sms</span>
                        </div>
                        <h4 class="mt-3 text-base font-semibold text-slate-800">Multi‑channel notifications</h4>
                        <p class="mt-2 text-sm text-slate-600">In‑app, email, SMS via mNotify, and WhatsApp (optional) ensure everyone gets the message.</p>
                    </div>
                </div>
            </div>
        </section>

        <section class="py-12 lg:py-16">
            <div class="max-w-6xl mx-auto px-4 lg:px-6 text-center">
                <h2 class="text-2xl md:text-3xl font-bold text-slate-900">Ready to bring everyone together?</h2>
                <p class="mt-3 text-slate-600">Create your family space in minutes and start sharing updates that matter.</p>
                <div class="mt-8 flex items-center justify-center gap-3">
                    <a href="{{ route('register') }}" class="inline-flex items-center gap-2 bg-primary text-white px-5 py-3 rounded-xl shadow-sm">
                        <span class="material-symbols-rounded">sparkles</span>
                        Get started free
                    </a>
                    <a href="{{ route('login') }}" class="inline-flex items-center gap-2 bg-white text-slate-700 border border-slate-200 px-5 py-3 rounded-xl hover:bg-slate-50">
                        <span class="material-symbols-rounded">login</span>
                        Sign in
                    </a>
                </div>
            </div>
        </section>

        <footer class="py-8 border-t border-slate-200 bg-white">
            <div class="max-w-6xl mx-auto px-4 lg:px-6 text-center text-sm text-slate-500">
                © {{ date('Y') }} {{ config('app.name', 'FamilyTree') }} · All rights reserved
            </div>
        </footer>
    </main>
</body>
</html>
