@extends('layouts.app')

@section('title', 'Post · FamilyTree')
@section('page-title', 'Post')

@section('content')
    <article class="glass-card rounded-2xl shadow-card border border-white/60 overflow-hidden">
        <header class="p-6 flex items-start gap-3">
            <img src="{{ $post->author?->person?->photo_url ?? 'https://ui-avatars.com/api/?name='.urlencode($post->author?->name ?? 'Member') }}" alt="{{ $post->author?->name }}" class="h-12 w-12 rounded-xl object-cover">
            <div class="flex-1">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="font-semibold text-ink">{{ $post->author?->name ?? 'Unknown Member' }}</p>
                        <p class="text-xs text-slate-500">{{ optional($post->created_at)->diffForHumans() }} · {{ $post->family?->name }}</p>
                    </div>
                </div>
                <p class="mt-3 text-sm text-slate-700 leading-relaxed whitespace-pre-line">{{ $post->content }}</p>
            </div>
        </header>

        @if(is_array($post->media) && count($post->media))
            <div class="px-6 pb-6 grid sm:grid-cols-2 gap-3">
                @foreach($post->media as $m)
                    @if(($m['type'] ?? '') === 'image')
                        <img src="{{ $m['url'] ?? '' }}" alt="Media" class="w-full rounded-lg object-cover">
                    @elseif(($m['type'] ?? '') === 'video')
                        <video src="{{ $m['url'] ?? '' }}" controls class="w-full rounded-lg"></video>
                    @else
                        <a href="{{ $m['url'] ?? '' }}" class="text-sm text-primary underline" target="_blank" rel="noopener">{{ $m['name'] ?? 'File' }}</a>
                    @endif
                @endforeach
            </div>
        @endif
    </article>
@endsection
