

<?php $__env->startSection('title', 'Invite Members · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Invite members to '.$family->name); ?>

<?php $__env->startSection('content'); ?>
    <section class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <h2 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Invite via Email or SMS</h2>
            <?php if(session('status')): ?>
                <div class="rounded-xl bg-emerald-50 text-emerald-700 px-4 py-2 text-sm"><?php echo e(session('status')); ?></div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('families.invite.send', $family)); ?>" class="space-y-4">
                <?php echo csrf_field(); ?>
                <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                    <div>
                        <label for="email" class="block text-sm text-slate-600 mb-1">Email</label>
                        <input id="email" name="email" type="email" value="<?php echo e(old('email')); ?>" placeholder="name@example.com" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-rose-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label for="phone" class="block text-sm text-slate-600 mb-1">Phone</label>
                        <input id="phone" name="phone" type="text" value="<?php echo e(old('phone')); ?>" placeholder="+233…" class="w-full rounded-xl border-slate-200 focus:border-primary focus:ring-primary" />
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="mt-1 text-xs text-rose-600"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <p class="text-xs text-slate-400">Provide at least one of Email or Phone.</p>
                <button type="submit" class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded text-base">send</span>
                    Send invite
                </button>
            </form>
        </div>

        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6 space-y-4">
            <h2 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Generate shareable link & QR</h2>
            <form method="POST" action="<?php echo e(route('families.invite.send', $family)); ?>" class="space-y-3">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="generate" value="1" />
                <p class="text-sm text-slate-600">Creates a tokenized invitation without email/phone. Share the link or QR with relatives.</p>
                <button type="submit" class="inline-flex items-center gap-2 bg-slate-900 text-white px-4 py-2.5 rounded-xl">
                    <span class="material-symbols-rounded text-base">qr_code_2</span>
                    Generate link & QR
                </button>
            </form>
        </div>
    </section>

    <section class="mt-8">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-sm font-semibold text-slate-600 uppercase tracking-wide">Recent invitations</h3>
                <a href="<?php echo e(route('families.index')); ?>" class="text-sm text-primary">Back to Families</a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-5">
                <?php $__empty_1 = true; $__currentLoopData = $invitations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invitation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php ($acceptUrl = rtrim(config('platform.frontend_url', config('app.url')), '/').'/invitations/accept/'.$invitation->token); ?>
                    <article class="rounded-2xl border border-slate-200/70 p-4 space-y-3">
                        <div class="flex items-start justify-between">
                            <div class="space-y-1">
                                <p class="text-sm font-medium text-slate-800">
                                    <?php echo e($invitation->email ?? ($invitation->phone ?? 'Shareable link')); ?>

                                </p>
                                <p class="text-xs text-slate-500">Status: <span class="font-medium capitalize"><?php echo e($invitation->status); ?></span></p>
                                <?php if($invitation->expires_at): ?>
                                    <p class="text-xs text-slate-400">Expires <?php echo e($invitation->expires_at->diffForHumans()); ?></p>
                                <?php endif; ?>
                            </div>
                            <span class="text-[10px] uppercase tracking-wide rounded-full px-2 py-0.5 <?php echo e($invitation->status === 'accepted' ? 'bg-emerald-50 text-emerald-700' : ($invitation->status === 'revoked' ? 'bg-rose-50 text-rose-700' : 'bg-amber-50 text-amber-700')); ?>">
                                <?php echo e($invitation->status); ?>

                            </span>
                        </div>
                        <div class="space-y-2">
                            <a href="<?php echo e($acceptUrl); ?>" target="_blank" class="text-xs text-primary break-all"><?php echo e($acceptUrl); ?></a>
                            <div class="flex items-center gap-2">
                                <button type="button" class="text-xs px-2 py-1 rounded-lg bg-primary/10 text-primary hover:bg-primary/20" data-copy="<?php echo e($acceptUrl); ?>">Copy link</button>
                            </div>
                        </div>
                        <div class="pt-2">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=160x160&data=<?php echo e(urlencode($acceptUrl)); ?>" alt="QR code" class="rounded-lg border border-slate-200" loading="lazy">
                        </div>
                    </article>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-slate-500">No invitations yet. Generate one or send via email/SMS above.</p>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('click', function(e){
        const btn = e.target.closest('[data-copy]');
        if(!btn) return;
        const text = btn.getAttribute('data-copy');
        navigator.clipboard.writeText(text).then(() => {
            btn.textContent = 'Copied!';
            setTimeout(() => btn.textContent = 'Copy link', 1200);
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/families/invite.blade.php ENDPATH**/ ?>