

<?php $__env->startSection('title', 'Manage Relationships · FamilyTree'); ?>
<?php $__env->startSection('page-title', 'Manage Relationships'); ?>

<?php $__env->startSection('content'); ?>
    <section class="space-y-6">
        <div class="glass-card rounded-2xl border border-white/60 shadow-card p-6">
            <div class="flex flex-col md:flex-row md:items-end gap-4 md:justify-between">
                <div>
                    <h2 class="text-base font-semibold text-slate-800"><?php echo e($family->name); ?></h2>
                    <p class="text-xs text-slate-500">Create and manage relationships between family members</p>
                </div>
                <div class="flex items-center gap-2">
                    <a href="<?php echo e(route('families.tree', $family)); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                        <span class="material-symbols-rounded text-base">account_tree</span>
                        View Tree
                    </a>
                    <a href="<?php echo e(route('families.index')); ?>" class="inline-flex items-center gap-1 text-sm bg-slate-100 text-slate-700 px-3 py-2 rounded-xl hover:bg-slate-200">
                        <span class="material-symbols-rounded text-base">chevron_left</span>
                        Back to directory
                    </a>
                </div>
            </div>
        </div>

        <?php if(session('status')): ?>
            <div class="rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-700 px-4 py-3"><?php echo e(session('status')); ?></div>
        <?php endif; ?>

        <?php if($canManage): ?>
            <div class="rounded-2xl border border-slate-100 bg-white p-6">
                <h3 class="text-sm font-semibold text-slate-700 mb-4">Add relationship</h3>
                <form method="POST" action="<?php echo e(route('families.relationships.manage.store', $family)); ?>" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block text-xs text-slate-500">Person A</label>
                        <select name="person_id" class="w-full rounded-xl border-slate-200" required>
                            <option value="">— Select member —</option>
                            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($m['id']); ?>" <?php if(old('person_id') == $m['id']): echo 'selected'; endif; ?>><?php echo e($m['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['person_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500">Relationship type</label>
                        <select name="type" class="w-full rounded-xl border-slate-200" required>
                            <?php ($types = ['parent'=>'Parent','child'=>'Child','spouse'=>'Spouse','sibling'=>'Sibling','guardian'=>'Guardian','ward'=>'Ward','other'=>'Other']); ?>
                            <option value="">— Select type —</option>
                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v=>$label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($v); ?>" <?php if(old('type') === $v): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="block text-xs text-slate-500">Person B</label>
                        <select name="related_person_id" class="w-full rounded-xl border-slate-200" required>
                            <option value="">— Select member —</option>
                            <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($m['id']); ?>" <?php if(old('related_person_id') == $m['id']): echo 'selected'; endif; ?>><?php echo e($m['name']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['related_person_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="grid grid-cols-2 gap-3">
                        <div>
                            <label class="block text-xs text-slate-500">Start date</label>
                            <input type="date" name="start_date" value="<?php echo e(old('start_date')); ?>" class="w-full rounded-xl border-slate-200" />
                            <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div>
                            <label class="block text-xs text-slate-500">End date</label>
                            <input type="date" name="end_date" value="<?php echo e(old('end_date')); ?>" class="w-full rounded-xl border-slate-200" />
                            <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-xs text-slate-500">Notes</label>
                        <textarea name="notes" rows="2" class="w-full rounded-xl border-slate-200"><?php echo e(old('notes')); ?></textarea>
                        <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="text-xs text-rose-600 mt-1"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="md:col-span-2">
                        <button class="inline-flex items-center gap-2 bg-primary text-white px-4 py-2.5 rounded-xl">
                            <span class="material-symbols-rounded">add</span>
                            Add relationship
                        </button>
                    </div>
                </form>
            </div>
        <?php endif; ?>

        <div class="rounded-2xl border border-slate-100 bg-white p-6 overflow-auto">
            <h3 class="text-sm font-semibold text-slate-700 mb-3">Existing relationships</h3>
            <table class="w-full text-sm">
                <thead>
                    <tr class="text-left text-slate-500">
                        <th class="py-2">Person A</th>
                        <th class="py-2">Type</th>
                        <th class="py-2">Person B</th>
                        <th class="py-2">Dates</th>
                        <th class="py-2">Notes</th>
                        <th class="py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $relationships; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php ($a = $rel->person); ?>
                        <?php ($b = $rel->relatedPerson); ?>
                        <tr class="border-t border-slate-100">
                            <td class="py-2"><?php echo e(trim(($a->first_name ?? '').' '.($a->last_name ?? '')) ?: 'Member'); ?></td>
                            <td class="py-2">
                                <span class="inline-flex items-center gap-1 px-2 py-0.5 rounded-full text-xs bg-slate-100 text-slate-700">
                                    <span class="material-symbols-rounded text-sm">link</span>
                                    <?php echo e(ucfirst($rel->type)); ?>

                                </span>
                            </td>
                            <td class="py-2"><?php echo e(trim(($b->first_name ?? '').' '.($b->last_name ?? '')) ?: 'Member'); ?></td>
                            <td class="py-2 text-xs text-slate-500">
                                <?php if($rel->start_date): ?> <?php echo e($rel->start_date->toDateString()); ?> <?php endif; ?>
                                <?php if($rel->end_date): ?> — <?php echo e($rel->end_date->toDateString()); ?> <?php endif; ?>
                            </td>
                            <td class="py-2 text-xs text-slate-600 max-w-xs"><?php echo e(\Illuminate\Support\Str::limit($rel->notes, 80)); ?></td>
                            <td class="py-2 whitespace-nowrap">
                                <?php if($canManage): ?>
                                    <form method="POST" action="<?php echo e(route('families.relationships.manage.destroy', [$family, $rel])); ?>" onsubmit="return confirm('Remove this relationship?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="px-3 py-1.5 rounded-lg bg-rose-50 text-rose-700">Delete</button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="6" class="py-4 text-slate-500">No relationships yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="mt-3"><?php echo e($relationships->links()); ?></div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('head'); ?>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@24,400,0,0" />
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\familytree\api\resources\views/families/relationships/index.blade.php ENDPATH**/ ?>